package edu.uky.ai.csp.kr;

/**
 * A variable can be assigned one of several possible values.
 * 
 * @author Stephen G. Ware
 */
public class Variable {

	/** The variable's unique name */
	public final String name;
	
	/**
	 * Constructs a new variable.
	 * 
	 * @param name the variable's unique name
	 */
	public Variable(String name) {
		this.name = name;
	}
	
	@Override
	public boolean equals(Object other) {
		if(other instanceof Variable)
			return name.equals(((Variable) other).name);
		else
			return false;
	}
	
	@Override
	public int hashCode() {
		return name.hashCode();
	}
	
	@Override
	public String toString() {
		return name;
	}
}
